package main

import (
	"reflect"
	"storage_go/models"
	"testing"
)

type testPair struct {
	values string
	result []string
}

var tests = []testPair{
	{"https://google.com/some/path", []string{"google.com"} },
	{"https://www.google.com/some/path", []string{"google.com"} },
	{"8.8.8.8", []string{"dns.google."} },
	{"https://8.8.8.8/some/path", []string{"dns.google."} },
}

func TestPrepareData(t *testing.T){
	for _, test := range tests {
		testsResult := models.ParseIpPrepareData(test.values)
		for _, testResult := range testsResult{
			if !reflect.DeepEqual(testsResult, test.result){
				t.Error(
					"For", test.values,
					"expected", test.result,
					"got", testResult,
				)
			}
		}
	}
}